#!/usr/bin/env bash
#
# Environment variables that must be defined prior to running the containers.
# These are used in docker-compose.yml.
#

# POSTGRES_PASSWORD: Password for the super user in Postgres.
export POSTGRES_PASSWORD=changeme

# PG_TD_PASSWORD: Password for the 'tethysdash' user in Postgres.
export PG_TD_PASSWORD=changeme

# POSTGRES_DATA: Postgres data directory.
export POSTGRES_DATA=$PWD/pg_data

# POSTGRES_HOST_PORT: Host port where the Postgres service will be exposed.
# Useful to be able to connect to the 'tethysdash' database from outside the container.
# The default value here (5432) is the typical Postgres server port, but you will
# have to change it if there's some other host service listening on this port.
export POSTGRES_HOST_PORT=5432

# TETHYSDASH_CONFIG_DIR: Directory containing TethysDash.conf.
export TETHYSDASH_CONFIG_DIR=$PWD/config

# TETHYSDASH_DATA: Directory for the data directly managed by TethysDash.
export TETHYSDASH_DATA=$PWD/td_data

# TETHYSDASH_EMAILLOGS: Directory under which all email logs will be stored.
export TETHYSDASH_EMAILLOGS=$PWD/emaillogs

# TETHYSDASH_HOST_PORT: Host port where the TethysDash service will be exposed.
# Again, adjust as needed.
export TETHYSDASH_HOST_PORT=18080

# LRAUV_REPOS: Directory containing the LRAUV configuration and mission git clones.
export LRAUV_REPOS=$PWD/lrauv-repos
# (The subdirectories must be named lrauv-config and lrauv-mission respectively.)
