# tethysdash-instance-template

The contents of this directory is used as a template to facilitate
setting up a new integrated TethysDash system.
Only requirements on the target machine are
[Docker Engine](https://docs.docker.com/engine/installation/)
and [Docker Compose](https://docs.docker.com/compose/install/).

With this template the user can focus on the needed configuration
and let Docker take care of pulling the service images and launching
the TethysDash system.

## Building the template release

- Adjust as needed the image versions in docker-compose.yml

- Create tarball:

       ./create_release.sh
    
- Upload `tethysdash-instance-template.tgz` to
  https://bitbucket.org/mbari/tethysdash-docker/downloads/. 

## Using the template

Note: The main documentation page for TethysDash installation and configuration using Docker is 
[https://docs.mbari.org/tethysdash/install/docker/](https://docs.mbari.org/tethysdash/install/docker/),
which explains how to use the template in more detail.

In a nutshell, the steps for the end-user to use the template are as follows.

### Get the template

Download the latest `tethysdash-instance-template.tgz` release from
[https://bitbucket.org/mbari/tethysdash-docker/downloads/](https://bitbucket.org/mbari/tethysdash-docker/downloads/)
and expand the tarball on the target machine:

    mkdir tethysdash
    cd    tethysdash
    tar xf path/to/downloaded/tethysdash-instance-template.tgz

The expanded directory tree should look like this:

        .
        ├── README.md
        ├── setenv.sh
        ├── config
        │   ├── TethysDash.conf
        │   └── stations.json
        └── docker-compose.yml

### Environment variables

`setenv.sh` can be used to define a number of environment variables
that are used in later steps:

- Edit `setenv.sh` to review and adjust the variables as needed.
- On the command line, prior to launching the system, 
  "source" `setenv.sh` to expose the variables to the
  environment: `$ source setenv.sh`
  
### Configuration

- Edit `config/TethysDash.conf`, which is the master configuration for your instance.
  Various entries in this file rely on environment variables defined
  as indicated above.

- Optionally, edit `config/stations.json`.

### Launching

`docker-compose.yml` specifies the services comprising the TethysDash system.
No changes are typically needed in this file unless otherwise
indicated in TethysDash documentation, release notes, or other communications.

Launch the TethysDash system:

      docker-compose up -d
